﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.IO;

namespace 電子文書回覧追跡ツール {
    class untoutchable {

        //制限されている場所の文書を開こうとした場合の処理
        public string untouchableFolderCopy(string path) {
            DialogResult ans = MessageBox.Show("「" + path + "」" + "\rは、制限された場所にあり、開くことは許されません。デスクトップに複写し、開きますか？", "確認", MessageBoxButtons.OKCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1);
            if(ans == DialogResult.OK) {
                string 文書コピー入れ = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory), "文書コピー入れ");
                if(!Directory.Exists(文書コピー入れ)) {
                    Directory.CreateDirectory(文書コピー入れ);
                }
                string toDesktop = Path.Combine(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory), "文書コピー入れ"), path.Substring(path.LastIndexOf('\\') + 1));
                if(Directory.Exists(path)) {
                    directoryCopy(path, toDesktop);//フォルダ
                }
                else if(File.Exists(path)) {
                    File.Copy(path, toDesktop, true);//ファイル
                }
                return toDesktop;
            }
            return "";
        }

        //ディレクトリ複写
        private static void directoryCopy(string sourceDirName, string destDirName) {
            DirectoryInfo dir = new DirectoryInfo(sourceDirName);
            DirectoryInfo[] subDirs = dir.GetDirectories();
            DirectoryInfo newdir = new DirectoryInfo(destDirName);
            if(!dir.Exists) {
                throw new DirectoryNotFoundException("Source directory does not exist or could not be found: " + sourceDirName);
            }
            if(!newdir.Exists) {
                newdir.Create();
            }
            FileInfo[] files = dir.GetFiles();
            foreach(FileInfo file in files) {
                string destFilePath = Path.Combine(destDirName, file.Name);
                FileInfo destFileInfo = new FileInfo(destFilePath);
                if(destFileInfo.Exists) {
                    destFileInfo.IsReadOnly = false;
                }
                file.CopyTo(destFilePath, true);
            }
            foreach(DirectoryInfo subdir in subDirs) {
                string temppath = Path.Combine(destDirName, subdir.Name);
                directoryCopy(subdir.FullName, temppath);//回帰
            }
            newdir.LastWriteTime = dir.LastWriteTime;
            newdir.CreationTime = dir.CreationTime;
        }
    }
}
